<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
interface OperatingexpensesDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Operatingexpenses 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param operatingexpense primary key
 	 */
	public function delete($operatingexpensesid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Operatingexpenses operatingexpense
 	 */
	public function insert($operatingexpense);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Operatingexpenses operatingexpense
 	 */
	public function update($operatingexpense);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOperatingexpensesname($value);

	public function queryByOperatingexpensestype($value);

	public function queryByOperatingexpensesvalue($value);

	public function queryByTempdelete($value);

	public function queryByCurrentdate($value);


	public function deleteByOperatingexpensesname($value);

	public function deleteByOperatingexpensestype($value);

	public function deleteByOperatingexpensesvalue($value);

	public function deleteByTempdelete($value);

	public function deleteByCurrentdate($value);


}
?>